<?php
require_once 'config.php';
session_start();

// simple login for panel
if (!isset($_SESSION['admin_logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['panel_pass'])) {
        if ($_POST['panel_pass'] === ADMIN_WEB_PASSWORD) {
            $_SESSION['admin_logged_in'] = true;
        } else {
            $error = "Password wrong";
        }
    } else {
        // show login form
        ?>
        <!doctype html><html><head><meta charset="utf-8"><title>Admin Login</title></head><body style="background:#111;color:#fff;font-family:Arial">
        <div style="width:400px;margin:60px auto;">
        <h2>Bot Admin Login</h2>
        <?php if(!empty($error)) echo "<div style='color:#f88'>$error</div>"; ?>
        <form method="post">
            <input name="panel_pass" placeholder="Admin Panel Password" style="width:100%;padding:8px"><br><br>
            <button type="submit" style="padding:8px 12px">Login</button>
        </form>
        </div></body></html>
        <?php
        exit;
    }
}

// Helper functions
function loadAdmins() {
    $j = ADMINS_FILE;
    if(!file_exists($j)) file_put_contents($j, json_encode([]));
    return json_decode(file_get_contents($j), true);
}
function saveAdmins($arr) {
    file_put_contents(ADMINS_FILE, json_encode(array_values($arr), JSON_PRETTY_PRINT));
}

// Handle form actions
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Add keyword
    if (isset($_POST["add_keyword"])) {
        $keyword = trim($_POST['keyword']);
        $reply = trim($_POST['reply']);
        if ($keyword && $reply) {
            $stmt = $conn->prepare("INSERT INTO keywords (keyword, reply) VALUES (?, ?)");
            $stmt->bind_param("ss", $keyword, $reply);
            $stmt->execute();
            $stmt->close();
            $conn->query("INSERT INTO logs (event_type, meta) VALUES ('keyword_add', '". $conn->real_escape_string($keyword) ."')");
        }
    }
    // Delete keyword
    if (isset($_POST['del_keyword'])) {
        $id = intval($_POST['keyword_id']);
        $stmt = $conn->prepare("DELETE FROM keywords WHERE id=?");
        $stmt->bind_param("i",$id);
        $stmt->execute();
        $stmt->close();
    }
    // block user
    if (isset($_POST['block_user'])) {
        $uid = intval($_POST['block_user_id']);
        $reason = $conn->real_escape_string($_POST['block_reason'] ?? '');
        $stmt = $conn->prepare("INSERT INTO blocked_users (user_id, reason) VALUES (?, ?) ON DUPLICATE KEY UPDATE reason=VALUES(reason)");
        $stmt->bind_param("is",$uid,$reason);
        $stmt->execute();
        $stmt->close();
        $conn->query("INSERT INTO logs (event_type, meta) VALUES ('block_user', '{$uid}')");
    }
    // unblock
    if (isset($_POST['unblock_user'])) {
        $uid = intval($_POST['unblock_user_id']);
        $stmt = $conn->prepare("DELETE FROM blocked_users WHERE user_id=?");
        $stmt->bind_param("i",$uid);
        $stmt->execute();
        $stmt->close();
    }
    // mute
    if (isset($_POST['mute_user'])) {
        $uid = intval($_POST['mute_user_id']);
        $minutes = intval($_POST['mute_minutes']);
        $until = date("Y-m-d H:i:s", time() + $minutes*60);
        $stmt = $conn->prepare("INSERT INTO muted_users (user_id, mute_until) VALUES (?, ?) ON DUPLICATE KEY UPDATE mute_until=VALUES(mute_until)");
        $stmt->bind_param("is",$uid,$until);
        $stmt->execute();
        $stmt->close();
    }
    // unmute
    if (isset($_POST['unmute_user'])) {
        $uid = intval($_POST['unmute_user_id']);
        $stmt = $conn->prepare("DELETE FROM muted_users WHERE user_id=?");
        $stmt->bind_param("i",$uid);
        $stmt->execute();
        $stmt->close();
    }
    // add admin by id
    if (isset($_POST['add_admin'])) {
        $uid = intval($_POST['admin_user_id']);
        $admins = loadAdmins();
        if (!in_array($uid, $admins)) { $admins[] = $uid; saveAdmins($admins); }
    }
    // remove admin
    if (isset($_POST['remove_admin'])) {
        $uid = intval($_POST['remove_admin_id']);
        $admins = loadAdmins();
        $admins = array_filter($admins, function($x) use($uid){ return $x != $uid; });
        saveAdmins($admins);
    }
}

// Fetch data
$keywords = $conn->query("SELECT * FROM keywords ORDER BY id DESC");
$blocked = $conn->query("SELECT * FROM blocked_users ORDER BY blocked_at DESC LIMIT 100");
$muted = $conn->query("SELECT * FROM muted_users ORDER BY muted_at DESC LIMIT 100");
$users = $conn->query("SELECT * FROM users ORDER BY last_seen DESC LIMIT 200");
$admins = loadAdmins();
$logs = $conn->query("SELECT * FROM logs ORDER BY created_at DESC LIMIT 200");

?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Bot Admin Panel</title>
<style>
body{font-family:Arial;background:#0b0b0b;color:#fff}
.container{width:1000px;margin:20px auto;padding:18px;background:#111;border-radius:8px}
input,textarea,select{width:100%;padding:8px;margin:6px 0;background:#0f0f0f;border:1px solid #222;color:#fff}
button{padding:8px 12px;background:#28a745;border:none;color:#fff;cursor:pointer;border-radius:4px}
.small{width:200px;display:inline-block}
.table{width:100%;border-collapse:collapse;margin-top:10px}
.table th,.table td{padding:8px;border:1px solid #222}
.section{margin-bottom:18px}
</style>
</head>
<body>
<div class="container">
<h2>🤖 Telegram Bot Admin Panel</h2>

<div class="section">
<h3>Add Keyword</h3>
<form method="post">
<input name="keyword" placeholder="keyword (case-insensitive search)" required>
<textarea name="reply" placeholder="reply text (can contain emojis)" required></textarea>
<button name="add_keyword">➕ Add Keyword</button>
</form>
</div>

<div class="section">
<h3>Saved Keywords</h3>
<table class="table">
<tr><th>ID</th><th>Keyword</th><th>Reply</th><th>Action</th></tr>
<?php while ($row = $keywords->fetch_assoc()) { ?>
<tr>
<td><?=htmlspecialchars($row['id'])?></td>
<td><?=htmlspecialchars($row['keyword'])?></td>
<td><?=htmlspecialchars($row['reply'])?></td>
<td>
<form method="post" style="display:inline">
<input type="hidden" name="keyword_id" value="<?=intval($row['id'])?>">
<button name="del_keyword" style="background:#c0392b">Delete</button>
</form>
</td>
</tr>
<?php } ?>
</table>
</div>

<div class="section">
<h3>Block / Unblock / Mute / Unmute</h3>
<form method="post" style="margin-bottom:10px">
<input name="block_user_id" placeholder="User ID to block">
<input name="block_reason" placeholder="Reason (optional)">
<button name="block_user">Block User</button>
</form>

<form method="post" style="margin-bottom:10px">
<input name="unblock_user_id" placeholder="User ID to unblock">
<button name="unblock_user" style="background:#3498db">Unblock User</button>
</form>

<form method="post" style="margin-bottom:10px">
<input name="mute_user_id" placeholder="User ID to mute">
<input name="mute_minutes" placeholder="Mute duration in minutes (0 for permanent)" value="60">
<button name="mute_user" style="background:#f39c12">Mute</button>
</form>

<form method="post">
<input name="unmute_user_id" placeholder="User ID to unmute">
<button name="unmute_user" style="background:#9b59b6">Unmute</button>
</form>
</div>

<div class="section">
<h3>Admins</h3>
<form method="post" style="margin-bottom:8px">
<input name="admin_user_id" placeholder="User ID to add as admin">
<button name="add_admin">Add Admin</button>
</form>
<form method="post">
<input name="remove_admin_id" placeholder="User ID to remove from admins">
<button name="remove_admin">Remove Admin</button>
</form>

<h4>Current Admins</h4>
<ul>
<?php foreach($admins as $a) echo "<li>".intval($a)."</li>"; ?>
</ul>
</div>

<div class="section">
<h3>Blocked Users (recent)</h3>
<table class="table"><tr><th>ID</th><th>Reason</th><th>Blocked At</th></tr>
<?php while ($r = $blocked->fetch_assoc()) { ?><tr>
<td><?=intval($r['user_id'])?></td><td><?=htmlspecialchars($r['reason'])?></td><td><?=htmlspecialchars($r['blocked_at'])?></td>
</tr><?php } ?>
</table>
</div>

<div class="section">
<h3>Muted Users (recent)</h3>
<table class="table"><tr><th>ID</th><th>Mute Until</th><th>Muted At</th></tr>
<?php while ($r = $muted->fetch_assoc()) { ?><tr>
<td><?=intval($r['user_id'])?></td><td><?=htmlspecialchars($r['mute_until'])?></td><td><?=htmlspecialchars($r['muted_at'])?></td>
</tr><?php } ?>
</table>
</div>

<div class="section">
<h3>Users (recent)</h3>
<table class="table"><tr><th>ID</th><th>Username</th><th>First</th><th>Last</th><th>Credits</th><th>Last Seen</th></tr>
<?php while ($r = $users->fetch_assoc()) { ?><tr>
<td><?=intval($r['user_id'])?></td>
<td><?=htmlspecialchars($r['username'])?></td>
<td><?=htmlspecialchars($r['first_name'])?></td>
<td><?=htmlspecialchars($r['last_name'])?></td>
<td><?=intval($r['credits'])?></td>
<td><?=htmlspecialchars($r['last_seen'])?></td>
</tr><?php } ?>
</table>
</div>

<div class="section">
<h3>Logs (recent)</h3>
<table class="table"><tr><th>Time</th><th>Event</th><th>Meta</th></tr>
<?php while ($r = $logs->fetch_assoc()) { ?><tr>
<td><?=htmlspecialchars($r['created_at'])?></td>
<td><?=htmlspecialchars($r['event_type'])?></td>
<td><?=htmlspecialchars($r['meta'])?></td>
</tr><?php } ?>
</table>
</div>

</div>
</body>
</html>