<?php
// connect.php - small example endpoint to validate keys from an app
require_once 'config.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$key = $input['key'] ?? '';
if (!$key) { echo json_encode(['ok'=>false,'error'=>'no_key']); exit; }

// Simple lookup in redeem_codes.json or DB - modify as needed
$codes = json_decode(file_get_contents(REDEEM_FILE), true);
foreach ($codes as $c) {
    if ($c['key'] === $key) {
        // ensure expiry check
        $exp = $c['expires'] ?? null;
        if ($exp && strtotime($exp) < time()) { echo json_encode(['ok'=>false,'error'=>'expired']); exit; }
        echo json_encode(['ok'=>true,'data'=>$c]); exit;
    }
}
echo json_encode(['ok'=>false,'error'=>'invalid']);